% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_get_dfp_data.R
\name{get_dfp_data}
\alias{get_dfp_data}
\title{Downloads and reads DFP datasets}
\usage{
get_dfp_data(
  companies_cvm_codes = NULL,
  first_year = 2010,
  last_year = lubridate::year(Sys.Date()),
  type_docs = c("BPA", "BPP", "DRE"),
  type_format = c("con", "ind"),
  clean_data = TRUE,
  use_memoise = FALSE,
  cache_folder = "gdfpd2_cache",
  do_shiny_progress = FALSE
)
}
\arguments{
\item{companies_cvm_codes}{Numeric CVM code  of companies. IF set to NULL (default), will return data for all available companies.}

\item{first_year}{First year of selected data}

\item{last_year}{Last year of selected data}

\item{type_docs}{Type of financial documents. E.g. c('DRE', 'BPA'). Definitions: '*' = fetch all docs,  'BPA' = Assets (ativos),
'BPP' = Liabilities (passivo),
'DRE' = income statement (demonstrativo de resultados),
'DFC_MD' = cash flow by direct method (fluxo de caixa pelo metodo direto),
'DFC_MI' = cash flow by indirect method (fluxo de caixa pelo metodo indireto),
'DMPL' = statement of changes in equity (mutacoes do patrimonio liquido),
'DVA' = value added report (desmonstrativo de valor agregado)}

\item{type_format}{Type of format of document (con = consolidated, ind = individual). Default = c('con', 'ind')}

\item{clean_data}{Clean data or return raw data? See read_dfp|itr_csv() for details}

\item{use_memoise}{Use memoise caching? If no (default), the function will read all .csv files. If yes, will use package
memoise for caching results (execution speed increases significantly)}

\item{cache_folder}{Path of cache folder to keep memoise and zip files}

\item{do_shiny_progress}{Whether to use shiny progress indicator (default = FALSE)}
}
\value{
A list of tibbles containing all requested financial data. Each element of the list is a table from DFP.
}
\description{
The DFP (demonstrativos financeiros padronizados) is the annual reporting system of companies
traded at B3. This function will access the CVM ftp and parse all available files according to user
choices
}
\examples{
\dontrun{
df_dfp <- get_dfp_data(companies_cvm_codes = NULL)
}
}
