% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{long_lat_to_cartesian}
\alias{long_lat_to_cartesian}
\title{Convert Geographic Coordinates to Cartesian Coordinates}
\usage{
long_lat_to_cartesian(long, lat, R = 6371)
}
\arguments{
\item{long}{Numeric vector of longitudes in degrees.}

\item{lat}{Numeric vector of latitudes in degrees.}

\item{R}{Radius of the Earth in kilometers (default: 6371 km).}
}
\value{
A numeric matrix with three columns (x, y, z) representing Cartesian coordinates.
}
\description{
This function converts geographic coordinates, given as longitude and latitude in degrees, to Cartesian coordinates (x, y, z) assuming a spherical Earth model.
}
\examples{
long <- c(-122.4194, 0)
lat <- c(37.7749, 0)
long_lat_to_cartesian(long, lat)
}
