% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFeatureCounts.R
\name{importFeatureCounts}
\alias{importFeatureCounts}
\title{Import from FeatureCounts}
\usage{
importFeatureCounts(file, skip = 0, headerLine = 2)
}
\arguments{
\item{file}{Character, file name}

\item{skip}{Number of lines to skip from txt file}

\item{headerLine}{Linenumber that contains the header information}
}
\value{
A list with expValues, geneInfo and summary
}
\description{
This functions imports the output from FeatureCounts
}
\details{
FeatureCounts produces two files, the txt that contain the expression values and then the summary that containts
all the information about the mapping statistics. This function imports both and stores them in a corresponding list.
}
\examples{

 # Define here the location on HDD for the example file
   fpath <- system.file("extdata","featureCountsExample.txt", package="GenomicTools.fileHandler")
 # Import the example featureCounts file  
   fcFile <- importFeatureCounts(file=fpath)
 
}
\author{
Daniel Fischer
}
