% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_iso_female.R
\name{create_iso_female}
\alias{create_iso_female}
\title{function to simulate creation of an isofemale line}
\usage{
create_iso_female(
  module = ancestry_module(),
  n = 1,
  inbreeding_pop_size = 100,
  run_time = 2000,
  num_threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{module}{Source population from which isofemales are generated}

\item{n}{Number of isofemales to be generated}

\item{inbreeding_pop_size}{Population size of the population used to generate
homozygous individuals}

\item{run_time}{Maximum runtime used for inbreeding}

\item{num_threads}{number of threads. Default is 1. Set to -1 to use all
available threads}

\item{verbose}{Displays verbose output if TRUE. Default value is FALSE}
}
\value{
A list of length \code{n}, where each entry is a fully homozygous
isofemale.
}
\description{
create_isofemale simulates the creation of an isofemale line
through extreme inbreeding.
}
\details{
To create an isofemale, two individuals are randomly picked from
the source population. Using these two individuals, a new population is
seeded, of size \code{inbreeding_pop_size}. Then, this population is allowed
to inbreed until either \code{run_time} is reached, or until all individuals
are homozygous and genetically identical, whatever happens first.
}
