% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_run_genotyping.R
\name{Run_Genotyping}
\alias{Run_Genotyping}
\title{Launch genotyping phase in parallel}
\usage{
Run_Genotyping(
  data_clustering,
  res_clust,
  ploidy,
  SeuilNoCall = 0.85,
  SeuilNbSD = 2.8,
  SeuilSD = 0.28,
  n_core = 1,
  corres_ATCG = NULL,
  pop = "Yes",
  cr_marker = 0.97,
  fld_marker = 3.4,
  hetso_marker = -0.3,
  save_n = "",
  batch = "",
  ALL = TRUE,
  path_log = ""
)
}
\arguments{
\item{data_clustering}{dataframe result from create dataset phase}

\item{res_clust}{object from clustering phase}

\item{ploidy}{ploidy of offspring}

\item{SeuilNoCall}{threshold of the probability of belonging to a cluster}

\item{SeuilNbSD}{threshold for the distance between an individuals and his cluster (x=Contrast)}

\item{SeuilSD}{threshold for the standard deviation of a cluster (SeuilSD*(1+0.5*abs(mean_contrast_cluster)))}

\item{n_core}{number of cores used for parallelization}

\item{corres_ATCG}{dataframe with the correspondence between A/B of AXAS and A/T/C/G (three columns : probeset_id, Allele_A, Allele_B)}

\item{pop}{Yes or No : are individuals from a same population}

\item{cr_marker}{call rate threshold}

\item{fld_marker}{FLD threshold}

\item{hetso_marker}{HetSO threshold}

\item{save_n}{name of the saving file. If '' no auto save and return value is changed}

\item{batch}{batch number in case of parallelization else ignore}

\item{ALL}{TRUE/FALSE whether the dataset has been cut or not (from the shiny app)}

\item{path_log}{path for log file when run by the shiny app}
}
\value{
if save_n != '' : 3 objects list : dataframe with call rate by individuals, dataframe with call rate and other metrics of markers and another dataframe -- Automatically save results. Else : return list with genotype
}
\description{
Function that launch the genotyping phase from the dataset with SampleName, Contrast and SigStren for each markers and the result of the 'Run_clustering' function.
}
\examples{
\donttest{
data(GenoTriplo_to_clust)
data(GenoTriplo_to_geno)
res = Run_Genotyping(data_clustering=GenoTriplo_to_clust,
                     res_clust=GenoTriplo_to_geno,
                     ploidy=3)
}

}
