% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotResiduals}
\alias{PlotResiduals}
\title{Plot residuals versus each input variable.}
\usage{
PlotResiduals(
  x,
  y_pred,
  y,
  x_units = NULL,
  y_name = "y",
  y_units = "",
  pch = 1
)
}
\arguments{
\item{x}{A data frame with number of rows equal to the number of rows in
\code{y_pred} containing the input (explanatory) variables.}

\item{y_pred}{A data frame of predicted output values
made by \code{Predict} or \code{CrossValidate}.}

\item{y}{A vector of length equal to the number of rows in \code{y_pred}
containing the true output values.}

\item{x_units}{An optional vector of character strings containing the units
of the input variables in \code{x} (for labels).}

\item{y_name}{An optional character string containing the output variable name
(for labels).}

\item{y_units}{An optional character string constaining the units
of the output variable (for labels).}

\item{pch}{Plotting symbol for \code{plot}; default is open circle.}
}
\value{
No return value, generates plots.
}
\description{
Plot residuals versus each input variable.
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
borehole_cv <- CrossValidate(borehole_fit)
}
PlotResiduals(x, borehole_cv, y)
}
