% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTP.R
\name{dDTP}
\alias{dDTP}
\alias{rDTP}
\title{The DTP-Student-t Distribution}
\usage{
dDTP(x, theta, sigma1, sigma2, delta1, delta2)

rDTP(n, theta, sigma1, sigma2, delta1, delta2)
}
\arguments{
\item{x}{vector of quantiles.}

\item{theta}{vector of the location parameters.}

\item{sigma1}{vector of the scale parameters of the left skewed part.}

\item{sigma2}{vector of the scale parameters of the right skewed part.}

\item{delta1}{the degree of freedom of the left skewed part.}

\item{delta2}{the degree of freedom of the right skewed part.}

\item{n}{number of observations.}
}
\value{
\code{dDTP} gives the density. \code{rDTP} generates random deviates.
}
\description{
The DTP-Student-t Distribution
}
\details{
The DTP-Student-t distribution has density
\deqn{f_{\mathrm{DTP}}\left(y \mid \theta, \sigma_1, \sigma_2, \delta_1, \delta_2\right)=w f_{\mathrm{LT}}\left(y \mid \theta, \sigma_1, \delta_1\right)+(1-w) f_{\mathrm{RT}}\left(y \mid \theta, \sigma_2, \delta_2\right),}
where \deqn{w=\frac{\sigma_1 f\left(0 \mid \delta_2\right)}{\sigma_1 f\left(0 \mid \delta_2\right)+\sigma_2 f\left(0 \mid \delta_1\right)},} \eqn{f(0 \mid \delta)} represents \deqn{f((y-\theta) / \sigma \mid \delta)\text{ evaluated at } y=\theta,} \deqn{f_{\mathrm{LT}}(y \mid \theta, \sigma, \delta)=\frac{2}{\sigma} f\left(\left.\frac{y-\theta}{\sigma} \right\rvert\, \delta\right) \mathbb{I}(y<\theta),} and \deqn{f_{\mathrm{RT}}(y \mid \theta, \sigma, \delta)=\frac{2}{\sigma} f\left(\left.\frac{y-\theta}{\sigma} \right\rvert\, \delta\right) \mathbb{I}(y \geq \theta).}
}
\examples{
set.seed(100)
require(graphics)

# Random Number Generation
X <- rDTP(n = 1e5,theta = 5,sigma1 = 7,sigma2 = 3,delta1 = 5,delta2 = 6)

# Plot the histogram
hist(X, breaks = 100, freq = FALSE)

# The red dashed line should match the underlining histogram
points(x = seq(-100,40,length.out = 1000),
       y = dDTP(x = seq(-100,40,length.out = 1000),
                theta = 5,sigma1 = 7,sigma2 = 3,delta1 = 5,delta2 = 6),
       type = "l",
       col = "red",
       lwd = 3,
       lty = 2)
}
\references{
See also \url{https://arxiv.org/pdf/2211.10776}.
}
