% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSSTDA_objects.R
\name{gene_selection}
\alias{gene_selection}
\title{gene_selection}
\usage{
gene_selection(
  full_data,
  survival_time,
  survival_event,
  control_tag_cases,
  gen_select_type,
  num_gen_select
)
}
\arguments{
\item{full_data}{Input matrix whose columns correspond to the patients and
rows to the genes.}

\item{survival_time}{Numerical vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
For the patients with tumour sample should be indicated the time between
disease diagnosis and death (if not dead until the end of follow-up)
and healthy patients must have an NA value.}

\item{survival_event}{Numerical vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
For the patients with tumour sample should be indicated whether
the patient has died (1) or not (0). Only these values are valid
and healthy patients must have an NA value.}

\item{control_tag_cases}{Character vector of the same length as the number of
columns of full_data. Patients must be in the same order as in full_data.
It must be indicated for each patient whether he/she is healthy or not.
One value should be used to indicate whether the patient is healthy and
another value should be used to indicate whether the patient's sample is
tumourous. The user will then be asked which one indicates whether
the patient is healthy. Only two values are valid in the vector in total.}

\item{gen_select_type}{Option. Options on how to select the genes to be
used in the mapper. Select the "Abs" option, which means that the
genes with the highest absolute value are chosen, or the
"Top_Bot" option, which means that half of the selected
genes are those with the highest value (positive value, i.e.
worst survival prognosis) and the other half are those with the
lowest value (negative value, i.e. best prognosis). "Top_Bot" default option.}

\item{num_gen_select}{Number of genes to be selected to be used in mapper.}
}
\value{
A \code{geneSelection_object}. It contains:
\itemize{
\item the \code{full_data} without NAN's values (\code{data})
\item the \code{cox_all_matrix} (a matrix with the results of the application of
proportional hazard models: with the regression coefficients, the odds ratios,
the standard errors of each coefficient, the Z values (coef/se_coef) and
the p-values for each Z value)
\item a vector with the name of the selected genes
\item the matrix of disease components with only the rows of the selected genes
(\code{genes_disease_component})
\item and the vector of the values of the filter function.
}
}
\description{
Private function to gene selection
}
\examples{
\donttest{
gen_select_type <- "Top_Bot"
percent_gen_select <- 10
control_tag_cases <- which(case_tag == "NT")
geneSelection_obj <- gene_selection(full_data, survival_time, survival_event, control_tag_cases,
gen_select_type ="top_bot", num_gen_select = 10)}
}
