% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoRegressor.rrBLUP}
\alias{phenoRegressor.rrBLUP}
\title{SNP-blup using rrBLUP package}
\usage{
phenoRegressor.rrBLUP(phenotypes, genotypes, covariances = NULL,
  extraCovariates = NULL, ...)
}
\arguments{
\item{phenotypes}{phenotypes, a numeric array (n x 1), missing values are predicted}

\item{genotypes}{SNP genotypes, one row per phenotype (n), one column per marker (m), values in 0/1/2 for
diploids or 0/1/2/...ploidy for polyploids. Can be NULL if \code{covariances} is present.}

\item{covariances}{square matrix (n x n) of covariances, ignored (included for coherence with other regressors).}

\item{extraCovariates}{optional extra covariates set, one row per phenotype (n), one column per covariate (w).
If NULL no extra covariates are considered.}

\item{...}{extra parameters are passed to rrBLUP::mixed.solve}
}
\value{
The function returns a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (k) predicted phenotypes
  \item \code{hyperparams} : named vector with the following keys: Vu, Ve, beta, LL
  \item \code{extradata}   : list with information on trained model, coming from \code{\link[rrBLUP]{mixed.solve}}
}
}
\description{
This is a wrapper around \code{rrBLUP} function \code{\link[rrBLUP]{mixed.solve}}.
Genotypes are modeled as random effects (matrix Z) and extra covariates,
if present, as fixed effects (matrix X).
Argument \code{covariances} is ignored.\cr
Please note that this function won't work if SNPs are not passed and if rrBLUP package is not installed.
}
\examples{
\dontrun{
#using the GROAN.pea dataset, we regress on the dataset and predict the first ten phenotypes
phenos = GROAN.pea.yield
phenos[1:10]  = NA

#calling the regressor with ridge regression BLUP on SNPs
results = phenoRegressor.rrBLUP(
  phenotypes = phenos,
  genotypes = GROAN.pea.SNPs,
  covariances = NULL,
  extraCovariates = NULL,
  SE = TRUE, return.Hinv = TRUE #rrBLUP-specific parameters
)

#examining the predictions
plot(GROAN.pea.yield, results$predictions,
     main = 'Train set (black) and test set (red) regressions',
     xlab = 'Original phenotypes', ylab = 'Predicted phenotypes')
points(GROAN.pea.yield[1:10], results$predictions[1:10], pch=16, col='red')

#printing correlations
test.set.correlation  = cor(GROAN.pea.yield[1:10], results$predictions[1:10])
train.set.correlation = cor(GROAN.pea.yield[-(1:10)], results$predictions[-(1:10)])
writeLines(paste(
  'test-set correlation :', test.set.correlation,
  '\\ntrain-set correlation:', train.set.correlation
))
}
}
\seealso{
\link[rrBLUP]{mixed.solve}

Other phenoRegressors: \code{\link{phenoRegressor.BGLR}},
  \code{\link{phenoRegressor.RFR}},
  \code{\link{phenoRegressor.SVR}},
  \code{\link{phenoRegressor.dummy}}
}
