% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.grin.colors.R
\name{default.grin.colors}
\alias{default.grin.colors}
\title{Default GRIN Colors}
\usage{
default.grin.colors(lsn.types)
}
\arguments{
\item{lsn.types}{Unique lesion types as specified in the lesion data file.}
}
\value{
Function return a vector of colors assigned to each unique lesion type.
}
\description{
Function assigns default colors for each lesion group in the whole set of GRIN plots.
}
\details{
The function specifies 10 colors for different lesion types. If the number of lesion types is more than 10, the user will be asked to specify the colors manually.
}
\examples{
data(lesion.data)

lsn.types=unique(lesion.data$lsn.type)
# assign colors for different lesion categories using default.grin.colors function:
default.grin.colors(lsn.types)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
