/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public class AvgQualTrimmer
extends AbstractSingleRecordTrimmer {
    private int qual;

    public AvgQualTrimmer(String args) {
        this.qual = Integer.parseInt(args);
    }

    public AvgQualTrimmer(int qual) {
        this.qual = qual;
    }

    public FastqRecord processRecord(FastqRecord in) {
        String seq = in.getSequence();
        int[] quals = in.getQualityAsInteger(true);
        int total = 0;
        for (int i = 0; i < seq.length(); ++i) {
            total += quals[i];
        }
        if (total < this.qual * seq.length()) {
            return null;
        }
        return in;
    }
}

