% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMBM.R
\name{plotMBM}
\alias{plotMBM}
\title{Plot the mesoscopic view  of the estimated MBM}
\usage{
plotMBM(resMBM, whichModel = 1, mycol = NULL, thres = 0.01, maxCurved = 3)
}
\arguments{
\item{resMBM}{A fitted Generalized BlockModel}

\item{whichModel}{The index corresponding to the model to plot (default is 1, the best model)}

\item{mycol}{A list of colors for the functional groups}

\item{thres}{A threshold under which edges correponding to probability of connections are not plotted}

\item{maxCurved}{graphical parameter : curvature of the edges}
}
\description{
Plot the mesocopic view of the multipartite network obtained by the Genreliazed block models. resMBM is the results of of MBM fitting (output of multipartiteBMFixedModel for given numbers of clusters or multipartiteBM if the number of clusters is selected)
}
\examples{
namesFG <- c('A','B')
list_pi <- list(c(0.5,0.5),c(0.3,0.7)) # prop of blocks in each FG
E  <-  rbind(c(1,2),c(2,2)) # architecture of the multipartite net.
typeInter <- c( "inc","diradj")
v_distrib <- c('gaussian','bernoulli')
list_theta <- list()
list_theta[[1]] <- list()
list_theta[[1]]$mean  <- matrix(c(6.1, 8.9, 6.6, 3), 2, 2)
list_theta[[1]]$var  <-  matrix(c(1.6, 1.6, 1.8, 1.5),2, 2)
list_theta[[2]] <- matrix(c(0.7,1.0, 0.4, 0.6),2, 2)
list_Net <- rMBM(v_NQ = c(30,30),E , typeInter, v_distrib, list_pi,
                list_theta, namesFG = namesFG, seed = 2)$list_Net
res_MBMsimu <- multipartiteBM(list_Net, v_distrib,
                              namesFG = c('A','B'), v_Kinit = c(2,2),
                              nbCores = 2,initBM = FALSE)
plotMBM(res_MBMsimu)
}
