% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{N4_sankey}
\alias{N4_sankey}
\title{Nutrient balance flow plot}
\usage{
N4_sankey(Nbalance_out)
}
\arguments{
\item{Nbalance_out}{data frame. Nutrient balance result from the Nutbalance()
function}
}
\value{
A Sankey diagram and a data frame with the some variable values
}
\description{
Nutrient balance flow in Sankey plot
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter to assess the basin model
alpha_p <- 35.09
alpha_l <- 0.02
sd_coef <- 0.2
# years in which the model should be executed
loc_years <- 1990:2018
# Computing the nutrient balance
nut_bal <- region_nut_balance(catch_data_TN, annual_data_TN, alpha_p, alpha_l,
sd_coef, loc_years)
# Plot the sankey plot with the result of the balance
sank <- N4_sankey(nut_bal)
}

}
