% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordering_functions.R
\name{order_outsidein}
\alias{order_outsidein}
\title{Outside-in ordering}
\usage{
order_outsidein(locs, lonlat = FALSE)
}
\arguments{
\item{locs}{A matrix of locations. Each row of \code{locs} contains a location, which can
be a point in Euclidean space R^d, a point in space-time R^d x T,
a longitude and latitude (in degrees) giving a point on the sphere,
or a longitude, latitude, and time giving a point in the sphere-time domain.}

\item{lonlat}{TRUE/FALSE whether locations are longitudes and latitudes.}
}
\value{
A vector of indices giving the ordering, i.e.
the first element of this vector is the index of the location farthest from the center.
}
\description{
Return the ordering of locations decreasing in their
distance to the average location.  Reverses middleout.
}
\examples{
n <- 100             # Number of locations
d <- 2               # dimension of domain
locs <- matrix( runif(n*d), n, d )
ord <- order_outsidein(locs)
}
