% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourierFunctions.R
\name{plotF}
\alias{plotF}
\title{Plot amplitude or argument of Fourier transform of a time series}
\usage{
plotF(x, dt = 1, units = "days", xlab = "f [cycles per day]",
  ylab = "|F(x)|", detrend = FALSE, add = FALSE, argument = FALSE, ...)
}
\arguments{
\item{x}{Time series}

\item{dt}{Time time interval, used to calculate frequencies}

\item{units}{Time unit, default = "days"}

\item{xlab}{x-label of plot}

\item{ylab}{y-label of plot}

\item{detrend}{If TRUE, series is detrended first. Default=FALSE}

\item{add}{If TRUE, plot is added to existing plot}

\item{argument}{If TRUE, plot the argument in stead of the modulus}

\item{...}{Arguments passed to plot()}
}
\value{
A plot of the amplitude of the Fourier transform, calculated with
fft(). No zero-padding or tapering is performed.
}
\description{
Plot amplitude or argument of Fourier transform of a time series
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
