% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistBP.R
\name{Level2NoLeafNodeBP}
\alias{Level2NoLeafNodeBP}
\title{Non-leaf GO-terms on a GO BP level}
\usage{
Level2NoLeafNodeBP(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{The organism of interest from the list of supported organism. If NULL the results are from the general
GO-DAG (default)}
}
\value{
A set of non-leaf GO-terms
}
\description{
This function returns all the non-leaf GO-terms on a particular GO BP level. The supported
            organism are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
           "Caenorhabditis elegans / Worm", "Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
           "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli"
}
\examples{
# Non-leaf nodes from level 13 GO-DAG
Level2NoLeafNodeBP(13)

# Non-leaf nodes from level 3 for Rat BP GO-DAG
Level2NoLeafNodeBP(3, "Rattus norvegicus")
}
