% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{GOBar}
\alias{GOBar}
\title{Z-score colored barplot.}
\usage{
GOBar(data, display, order.by.zscore = T, title, zsc.col)
}
\arguments{
\item{data}{A data frame containing at least the term ID and/or term, the
adjusted p-value and the z-score. A possible input can be generated with
the \code{circle_dat} function}

\item{display}{A character vector indicating whether a single plot ('single')
or a facet plot with panels for each category should be drawn
(default='single')}

\item{order.by.zscore}{Defines the order of the bars. If TRUE the bars are
ordered according to the z-scores of the processes. Otherwise the bars are
ordered by the negative logarithm of the adjusted p-value}

\item{title}{The title of the plot}

\item{zsc.col}{Character vector to define the color scale for the z-score of
the form c(high, midpoint,low)}
}
\description{
Z-score colored barplot of terms ordered alternatively by
  z-score or the negative logarithm of the adjusted p-value
}
\details{


If \code{display} is used to facet the plot the width of the panels
  will be proportional to the length of the x scale.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Building the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Creating the bar plot
GOBar(circ)

#Faceting the plot
GOBar(circ, display='multiple')
}
}

