% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.ng.trt.oc.df.r
\name{get.ss.ng.trt.oc.df}
\alias{get.ss.ng.trt.oc.df}
\title{Get single sample normal-gamma treament OC data.frame}
\usage{
get.ss.ng.trt.oc.df(
  mu.0.t = 0,
  n.0.t = 10,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  s.t = 2,
  n.t = 40,
  from.here = 0,
  to.here = 4,
  length.out = 1000,
  Delta.tv = 1.75,
  Delta.lrv = 1,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65
)
}
\arguments{
\item{mu.0.t}{prior mean}

\item{n.0.t}{prior effective sample size}

\item{alpha.0.t}{prior alpha parameter}

\item{beta.0.t}{prior beta parameter}

\item{s.t}{sample sd for treatment group}

\item{n.t}{sample size for treatment group}

\item{from.here}{treatment effect lower bound}

\item{to.here}{treatment effect upper bound}

\item{length.out}{number of points used to span (from.here, to.here)}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}
}
\value{
Returns a data.frame ready to create a treatment effect OC curve
}
\description{
Get single sample normal-gamma treament OC data.frame
}
\examples{
my.ss.ng.trt.oc.df <- get.ss.ng.trt.oc.df()
head(my.ss.ng.trt.oc.df)
}
\author{
Greg Cicconetti
}
