% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnorm.rp.r
\name{Reparameterized.normal}
\alias{Reparameterized.normal}
\alias{dnorm.rp}
\alias{pnorm.rp}
\alias{qnorm.rp}
\alias{rnorm.rp}
\title{Reparameterized normal functions}
\usage{
dnorm.rp(x, mean = 0, tau = 1, log = FALSE)

pnorm.rp(q, mean = 0, tau = 1, lower.tail = TRUE, log.p = FALSE)

qnorm.rp(p, mean = 0, tau = 1, lower.tail = TRUE, log.p = FALSE)

rnorm.rp(n, mean = 0, tau = 1)
}
\arguments{
\item{x}{likelihood function evaluates at point x}

\item{mean}{mean}

\item{tau}{precision parameter}

\item{log}{logical; if TRUE, probabilities p are given as log(p)}

\item{q}{quantile}

\item{lower.tail}{logical; if TRUE (default), probabilities are P(X < x) otherwise, P(X>x).}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{p}{cumulative probability}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
Returns density values, cumulative probabilities, quantiles and random samples from a normal distribution.
}
\description{
Reparameterized normal functions
}
\examples{
dnorm.rp(x=0)
pnorm.rp(q=.1)
qnorm.rp(p=.975)
rnorm.rp(10)
}
