\name{logLik.GNARfit}
\alias{logLik.GNARfit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Log-likelihood method for GNARfit objects
}
\description{
Returns the log-likelihood for a \code{GNARfit} object.
}
\usage{
\method{logLik}{GNARfit}(object,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
A \code{GNARfit} object generated by a \link[GNAR]{GNARfit} call.
}
\item{...}{Optional additional arguments, not used here.}
}
\details{
S3 method for the GNARfit class. The function returns the value of
\deqn{-TN/2 \log(2 \pi) - T/2 \log(| \Sigma |) - 1/2 trace(E \Sigma^{-1} E'),} where \eqn{T} is the time length of the observations, \eqn{N} is the number of nodes, \eqn{\Sigma =  E E' /T} is the estimated covariance matrix and \eqn{E} is the matrix of residuals.
}
\value{
A \code{logLik} object.
}

\examples{
#calculate log-likelihood for fiveNode data
#global alphas
logLik(GNARfit())
#individual alphas
logLik(GNARfit(globalalpha=FALSE))
}
