% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_binary.R
\name{score_binary}
\alias{score_binary}
\title{Binary Classification}
\usage{
score_binary(estimate, true, model_name = NULL)
}
\arguments{
\item{estimate}{Matrix. Estimated graph (adjacency matrix)}

\item{true}{Matrix. True graph (adjacency matrix)}

\item{model_name}{Character string. Name of the method or penalty
(defaults to \code{NULL})}
}
\value{
A data frame containing specificity (1 - false positive rate),
sensitivity (true positive rate), precision (1 - false discovery rate),
f1_score, and mcc (Matthews correlation coefficient).
}
\description{
Binary Classification
}
\examples{
\donttest{
p <- 20
n <- 500

true_net <- gen_net(p = p, edge_prob = 0.25)

y <- MASS::mvrnorm(n = n,
                   mu = rep(0, p),
                   Sigma = true_net$cors)

# default
fit_atan <- ggmncv(R = cor(y),
                   n = nrow(y),
                   penalty = "atan",
                   progress = FALSE)

# lasso
fit_l1 <- ggmncv(R = cor(y),
                 n = nrow(y),
                 penalty = "lasso",
                 progress = FALSE)

# atan scores
score_binary(estimate = true_net$adj,
             true = fit_atan$adj,
             model_name = "atan")

score_binary(estimate = fit_l1$adj,
             true = true_net$adj,
             model_name = "lasso")
}
}
