% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eip.R
\name{boot_eip}
\alias{boot_eip}
\title{Bootstrapped Edge Inclusion 'Probabilities'}
\usage{
boot_eip(Y, method = "pearson", samples = 500, progress = TRUE, ...)
}
\arguments{
\item{Y}{A matrix of dimensions \emph{n} by \emph{p}.}

\item{method}{Character string. Which correlation coefficient (or covariance)
is to be computed. One of "pearson" (default), "kendall",
or "spearman".}

\item{samples}{Numeric. How many bootstrap samples (defaults to \code{500})?}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE})?}

\item{...}{Additional arguments passed to \code{\link{ggmncv}}.}
}
\value{
An object of class \code{eip} that includes the "probabilities" in a
data frame.
}
\description{
\loadmathjax
Compute the number of times each edge was selected
when performing a non-parametric bootstrap
\insertCite{@see Figure 6.7, @hastie2009elements}{GGMncv}.
}
\note{
Although \insertCite{hastie2009elements;textual}{GGMncv} suggests
this approach provides probabilities, to avoid confusion with Bayesian inference,
these are better thought of as "probabilities" (or better yet proportions).
}
\examples{

\donttest{
# data (ptsd symptoms)
Y <- GGMncv::ptsd[,1:10]

# compute eip's
boot_samps <- boot_eip(Y, samples  = 100, progress = FALSE)

boot_samps
}
}
\references{
\insertAllCited{}
}
