% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{gforce.kmeans}
\alias{gforce.kmeans}
\title{K-means Clustering.}
\usage{
gforce.kmeans(X, K, R_only = FALSE)
}
\arguments{
\item{X}{\eqn{n x m} matrix. Each row is treated as a point in \eqn{R^m}.}

\item{K}{integer. The number of clusters to group the data into.}

\item{R_only}{logical expression. If \code{R_only == FALSE}, then the included
native code implementation will be used. Otherwise, an R implementation is used.}
}
\value{
Returns an object with the components:
\describe{
\item{\code{clusters}}{a \eqn{n} dimensional integer vector. Entry \eqn{i} to the cluster assignment of the data point given by row \eqn{i} of \code{X}.}
\item{\code{centers}}{a \eqn{K x m} numeric matrix. Row \eqn{i} corresponds to the center of cluster \eqn{i}.}
\item{\code{num_iters}}{an integer. Number of iterations of Lloyd's Algorithm.}
\item{\code{time}}{a numeric. Runtime of Lloyd's Algorithm.}
}
}
\description{
Solves the K-means problem using kmeans++ for the initialization and then 
runs Lloyd's algorithm.
}
\examples{
m <- 10 
n <- 10
X <- matrix(MASS::mvrnorm(m*n,rep(0,m*n),diag(m*n)), nrow = n)
km_res <- gforce.kmeans(X,3)

}
\references{
S.P. Lloyd. Least Squares Quantization in PCM. \emph{IEEE Transactions on Information Theory}, 1982.

D. Arthur and S. Vassilvitskii. k-means++: The Advantages of Careful Seeding. \emph{SODA}, 2007.
}
