% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glatent_confints.R
\name{gforce.glatent_confints}
\alias{gforce.glatent_confints}
\title{Confidence Intervals for Estimation in G-Latent Models.}
\usage{
gforce.glatent_confints(C_hat = NULL, X_vals = NULL, clusters = NULL,
  alpha = 0.05, graph = "latent", variance_estimator = "simple",
  use_cv = FALSE, cv_opts = NULL, lambda1 = NULL, lambda2 = NULL)
}
\arguments{
\item{C_hat}{a \eqn{d x d} matrix. This is the estimated latent or group averages covariance matrix.}

\item{X_vals}{a \eqn{n x d} matrix. This is a matrix where each row is a sample from the model.}

\item{clusters}{a \eqn{d} dimensional integer vector. Contains the assignment of variables to groups.}

\item{alpha}{a numeric. \code{alpha} is the confidence level.}

\item{graph}{a string. It can either have value \code{'latent'} or \code{'averages'}.}

\item{variance_estimator}{a string. It can either have value \code{'simple'} or \code{'exact'}.}

\item{use_cv}{logical expression. Indicates whether or not to use cross validation.}

\item{cv_opts}{an object. Contains options for cross validation procedure.}

\item{lambda1}{a numeric. Parameter for the first optimization problem.}

\item{lambda2}{a numeric. Parameter for the second optimization problem.}
}
\value{
a \eqn{d x d x 3} array. The first \eqn{d x d} slice is the lower confidence bound, the 
second the point estimate, and the third the upper confidence bound.
}
\description{
Estimate the precision matrix and construct confidence intervals for the latent and group averages graphs. The user
can either provide an estimate of the relevant covariance matrix or the data and cluster assignments. If cross validation
is selected, the data and clusters must be provided.
}
\examples{
K <- 5
n <- 50
d <- 50
dat <- gforce.generator(K,d,n,3,graph='scalefree')
th_tilde <- gforce.glatent_confints(X_vals = dat$X,clusters = dat$group_assignments,
                                    use_cv = TRUE,graph='latent')

}
\references{
C. Eisenach, F. Bunea, Y. Ning, and C. Dinicu. Efficient, High-Dimensional Inference for Cluster-Based Graphical Models. \emph{Manuscript submitted for publication}, 2018.
}
\seealso{
\code{\link{gforce.glatent_confints.cv_defaults}}
}
