% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PECOK.R
\name{gforce.Gamma}
\alias{gforce.Gamma}
\title{Estimates \eqn{\Gamma} for the PECOK SDP.}
\usage{
gforce.Gamma(X, par = FALSE, fast_estimator = FALSE, R_only = FALSE)
}
\arguments{
\item{X}{\eqn{n x d} matrix. Each row represents a realization of a
\eqn{d} dimensional random vector.}

\item{par}{logical expression. If \code{par == TRUE}, then a multi-threaded version
of the function is called. If \code{par == FALSE}, a single-threaded version is called.}

\item{fast_estimator}{logical expression. If \code{fast_estimator == TRUE}, then the alternative
estimator for \eqn{\hat \Gamma} is used.}

\item{R_only}{logical expression. If \code{R_only == TRUE}, then no native code is run. If 
\code{fast_estimator != TRUE} this is ignored.}
}
\value{
The estimator \eqn{\Gamma} as a \eqn{d} dimensional numeric vector.
}
\description{
In particular, it returns in diagonal form the estimator
\eqn{\Gamma} used to construct the PECOK penalized covariance estimator.
}
\examples{
dat <- gforce.generator(5,20,20,3)
gam_hat <- gforce.Gamma(dat$X)

}
\references{
F. Bunea, C. Giraud, M. Royer and N. Verzelen. PECOK: a convex optimization approach to variable clustering. \emph{arXiv:1606.05100}, 2016.
}
