% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.global_envelope2d}
\alias{plot.global_envelope2d}
\title{Plotting function for 2d global envelopes}
\usage{
\method{plot}{global_envelope2d}(
  x,
  fixedscales = TRUE,
  what = c("obs.sign", "obs", "lo", "hi", "lo.sign", "hi.sign"),
  sign.type = c("circles", "contour", "col"),
  sign.col = c("blue", "red"),
  transparency = 155/255,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A 'global_envelope' object for two-dimensional functions}

\item{fixedscales}{Logical. TRUE for the same scales for all images.}

\item{what}{Character vector specifying what information should be plotted for 2d functions.
A combination of:
Observed (\code{"obs"}), upper envelope (\code{"hi"}), lower envelope (\code{"lo"}),
observed with significantly higher values highlighted (\code{"hi.sign"}),
observed with significantly lower values highlighted (\code{"lo.sign"}),
observed with significantly (lower and higher) values highlighted (\code{"obs.sign"}).
Default to the last one. Combination c("obs", "lo", "hi", "lo.sign", "hi.sign") can
also be of interest (earlier default).}

\item{sign.type}{Either \code{"col"} for color showing the significant region, or
\code{"contour"} for colored contour showing the significant region, or
\code{"circles"} for plotting circles at locations where the observed function
exceeds the envelope: diameters proportional to (obs-hi)/(hi-lo) for values
above the envelope and (lo-obs)/(hi-lo) for values below the envelope.
In the one-sided (testing) case, the divisors are instead (hi-central) (case 'greater')
and (central-lo) (case 'less').
Default to \code{"circles"}.}

\item{sign.col}{A vector of length two giving the colors for significant parts
below the envelope (first value) and above the envelope (second value).}

\item{transparency}{A number between 0 and 1 (default 155/255, 60% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions for 2d
functions.}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{...}{Ignored.}
}
\description{
If more than one envelope has been calculated (corresponding to several coverage/alpha),
only the largest one is plotted.
}
\seealso{
\code{\link{graph.flm}}
}
