% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve-set.r
\name{subset.curve_set}
\alias{subset.curve_set}
\title{Subsetting curve sets}
\usage{
\method{subset}{curve_set}(x, subset, ...)
}
\arguments{
\item{x}{A \code{curve_set} object.}

\item{subset}{A logical expression indicating curves to keep.}

\item{...}{Ignored.}
}
\description{
Return subsets of curve sets which meet conditions.
}
\examples{
if(require("fda.usc", quietly=TRUE)) {
  # Prepare data
  data("poblenou")
  Free <- poblenou$df$day.festive == 1 |
    as.integer(poblenou$df$day.week) >= 6
  MonThu <- poblenou$df$day.festive == 0 & poblenou$df$day.week \%in\% 1:4
  Friday <- poblenou$df$day.festive == 0 & poblenou$df$day.week == 5

  # Data as a curve_set
  cset <- create_curve_set(list(r=0:23,
             obs=t(poblenou[['nox']][['data']])))
  plot(subset(cset, MonThu))
  plot(subset(cset, Friday))
  plot(subset(cset, Free))
}
}
