% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_Plot.R
\name{Estimate_Plot}
\alias{Estimate_Plot}
\title{Generate parameter estimate plot with 95 percent CI's from a GERGM object.}
\usage{
Estimate_Plot(GERGM_Object, normalize_coefficients = FALSE,
  coefficients_to_plot = c("both", "covariate", "structural"),
  coefficient_names = NULL, leave_out_coefficients = NULL,
  comparison_model = NULL, model_names = NULL, text_size = 12)
}
\arguments{
\item{GERGM_Object}{The object returned by the estimation procedure using the
GERGM function.}

\item{normalize_coefficients}{Defaults to FALSE, if TRUE then parameter
estimates will be converted be deivided by their standard deviations with
and displayed with 95 percent confidence intervals. These coefficients will
no longer be comparable, but make graphical interpretation of significance
and sign easier.}

\item{coefficients_to_plot}{An optional argument indicating which kind of
parameters to plot. Can be one of "both","covariate", or "structural". Useful
for creating separate parameter plots for covariates and structural
parameters when these parameters are on very different scales.}

\item{coefficient_names}{Defualts to NULL. Can be a string vector of names
for coefficients to be used in making publication quality plots.}

\item{leave_out_coefficients}{Defaults to NULL. Can be a string vector of
coefficient names as they appear in the plot. These coefficients will be
removed from the final plot. Useful if the intercept term is much larger in
magnitude than other estimates, and the user wishes to clarify the other
parameter estimates without normalizing.
given}

\item{comparison_model}{A GERGM_Object produced by an alternative model whose
parameter estimates are to be compared to the existing model. Defaults to
NULL.}

\item{model_names}{If a comparison_model is provided, then each model must be
given a name via the model_names parameter. Defaults to NULL.}

\item{text_size}{The base size for axis text. Defaults to 12.}
}
\value{
A parameter estimate plot.
}
\description{
Generate parameter estimate plot with 95 percent CI's from a GERGM object.
}

