% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_to_beta.R
\name{rate_to_beta}
\alias{rate_to_beta}
\alias{beta_to_rate}
\title{Conversion between a Rate Vector and a Beta Vector}
\usage{
rate_to_beta(x)

beta_to_rate(x)
}
\arguments{
\item{x}{a vector.}
}
\value{
a vector.
}
\description{
Conversion between a rate vector and a beta vector.
For an economic agent, the rate vector indicates the proportional relationship between expenditures on physical commodities and financial instruments.
The first element of the rate vector indicates the quantity of the physical commodity needed to obtain a unit of output.
Other elements indicate the ratio of expenditures on various financial instruments to that of the physical commodity.
The beta vector indicates the proportion of expenditures on various commodities.
}
\section{Functions}{
\itemize{
\item \code{rate_to_beta}: Convert a rate vector to a beta vector.

\item \code{beta_to_rate}: Convert a beta vector to a rate vector.
When converting the beta vector into a rate vector, it will be assumed that the first element of these two vectors is the same.
}}

\examples{
\donttest{
rate_to_beta(c(1, 1 / 3, 1 / 4))
rate_to_beta(c(0.5, 1 / 3, 1 / 4))

x <- beta_to_rate(c(0.7, 0.1, 0.2))
rate_to_beta(x)
}
}
\seealso{
\cite{\link{demand_coefficient}}
}
