% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMSCDM.R
\name{GMSCDM}
\alias{GMSCDM}
\title{Estimating multiple-strategy cognitive diagnosis models}
\usage{
GMSCDM(dat, msQ, model = "ACDM", s = 1, att.prior = NULL,
  delta = NULL, control = list())
}
\arguments{
\item{dat}{A required binary item response matrix}

\item{msQ}{A multiple-strategy Q-matrix; the first column gives item numbers and the second column gives
the strategy number. See examples.}

\item{model}{CDM used; can be \code{"DINA"},\code{"DINO"},\code{"ACDM"},\code{"LLM"}, and \code{"RRUM"}, representing
the GMS-DINA, GMS-DINO, GMS-ACDM, GMS-LLM and GMS-RRUM in Ma & Guo (2019), respectively. It can also be \code{"rDINA"} and \code{"rDINO"},
representing restricted GMS-DINA and GMS-DINO models where delta_{jm1} are equal for all strategies. Note that only a single model can be used
for the whole test.}

\item{s}{strategy selection parameter. It is equal to 1 by default.}

\item{att.prior}{mixing proportion parameters.}

\item{delta}{delta parameters in list format.}

\item{control}{a list of control arguments}
}
\value{
an object of class \code{GMSCDM} with the following components:
\describe{
\item{IRF}{A matrix of success probabilities for each latent class on each item (IRF)}
\item{delta}{A list of delta parameters}
\item{attribute}{A list of estimated attribute profiles including EAP, MLE and MAP estimates.}
\item{testfit}{A list of test fit statistics including deviance, number of parameters, AIC and BIC}
\item{sIRF}{strategy-specific item response function}
\item{pjmc}{Probability of adopting each strategy on each item for each latent class}
\item{sprv}{Strategy pravelence}
}
}
\description{
An (experimental) function for calibrating the multiple-strategy CDMs for dichotomous response data (Ma & Guo, 2019)
}
\examples{
\dontrun{
##################
#
# data simulation
#
##################
set.seed(123)
msQ <- matrix(
c(1,1,0,1,
1,2,1,0,
2,1,1,0,
3,1,0,1,
4,1,1,1,
5,1,1,1),6,4,byrow = T)
# J x L - 00,10,01,11
LC.prob <- matrix(c(
0.2,0.7727,0.5889,0.8125,
0.1,0.9,0.1,0.9,
0.1,0.1,0.8,0.8,
0.2,0.5,0.4,0.7,
0.2,0.4,0.7,0.9),5,4,byrow=TRUE)
N <- 10000
att <- sample(1:4,N,replace=TRUE)
dat <- 1*(t(LC.prob[,att])>matrix(runif(N*5),N,5))


est <- GMSCDM(dat,msQ)
# item response function
est$IRF
# strategy specific IRF
est$sIRF


################################
#
# Example 14 from GDINA function
#
################################
Q <- matrix(c(1,1,1,1,0,
1,2,0,1,1,
2,1,1,0,0,
3,1,0,1,0,
4,1,0,0,1,
5,1,1,0,0,
5,2,0,0,1),ncol = 5,byrow = TRUE)
d <- list(
  item1=c(0.2,0.7),
  item2=c(0.1,0.6),
  item3=c(0.2,0.6),
  item4=c(0.2,0.7),
  item5=c(0.1,0.8))

  set.seed(123)
sim <- simGDINA(N=1000,Q = Q, delta.parm = d,
               model = c("MSDINA","MSDINA","DINA",
                         "DINA","DINA","MSDINA","MSDINA"))

# simulated data
dat <- extract(sim,what = "dat")
# estimation
# MSDINA need to be specified for each strategy
est <- GDINA(dat,Q,model = c("MSDINA","MSDINA","DINA",
                             "DINA","DINA","MSDINA","MSDINA"),
             control = list(conv.type = "neg2LL",conv.crit = .01))

# Approximate the MS-DINA model using GMS DINA model
est2 <- GMSCDM(dat, Q, model = "rDINA", s = 10,
               control = list(conv.type = "neg2LL",conv.crit = .01))
}


}
\references{
Ma, W., & Guo, W. (2019). Cognitive Diagnosis Models for Multiple Strategies. \emph{British Journal of Mathematical and Statistical Psychology.}
}
\seealso{
\code{\link{GDINA}} for MS-DINA model and single strategy CDMs,
and \code{\link{DTM}} for diagnostic tree model for multiple strategies in polytomous response data
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu}}
}
