% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_chroma.R
\name{simple_chroma}
\alias{simple_chroma}
\title{Simulate simple chromatograms}
\usage{
simple_chroma(peaks = c(10, 13, 25, 37, 50), N = 1, min = 0, max = 30,
  Names = NULL, sd = NULL)
}
\arguments{
\item{peaks}{A numeric vector giving the retention times on which gaussian distribution, defining peaks, are centered. If more than one sample is generated \code{N > 1}, \code{peaks} defines a population of peaks, from which samples are generated.}

\item{N}{An integer giving the number of chromatograms to create. By default \code{N = 1}.}

\item{min}{A numeric giving the minimum retention time.}

\item{max}{A numeric giving the maximum retention time.}

\item{Names}{A character vector giving sample names. If not specified, names are generated automatically.}

\item{sd}{A numeric vector of the same length as peaks giving the standard deviation of each peak. Only supported if N = 1.}
}
\value{
A data frame containing x and y coordinates and corresponding sample names.
}
\description{
Creates chromatograms with user defined peaks for illustrative purposes. Linear drift is applied in sample order if more than one sample is created. See parameters of the function.
}
\examples{
## create a chromatogram
x <- simple_chroma(peaks = c(5,10,15), N = 1, min = 0, max = 30, Names = "MyChroma")
## plot chromatogram
with(x, plot(x,y, xlab = "time", ylab = "intensity"))

}
\author{
Meinolf Ottensmann (meinolf.ottensmann@web.de) & Martin Stoffel (martin.adam.stoffel@gmail.com)
}
