% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_COX_gaga}
\alias{cpp_COX_gaga}
\title{Fit a Cox model via the GAGA algorithm using cpp.}
\usage{
cpp_COX_gaga(
  X,
  y,
  cens,
  alpha = 2,
  itrNum = 50L,
  thresh = 0.001,
  flag = TRUE,
  lamda_0 = 0.5,
  fdiag = TRUE
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.}

\item{y}{A n*1 matrix, indicating the survival time;}

\item{cens}{A n*1 matrix, consists of 0 and 1, 1 indicates that the row of data is censored, 0 is opposite.}

\item{alpha}{Hyperparameter. The suggested value for alpha is 2 or 3.}

\item{itrNum}{The number of iteration steps. In general, 20 steps are enough.}

\item{thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{lamda_0}{The initial value of the regularization parameter for ridge regression.}

\item{fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}
}
\value{
Coefficient vector
}
\description{
Fit a Cox model via the Global Adaptive Generative Adjustment algorithm.
Part of this function refers to the coxphfit function in MATLAB 2016b.
}
