% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GADGET.R
\docType{package}
\name{GADGET}
\alias{GADGET}
\title{Gaussian Process Approximations for Designing Experiment}
\description{
The \code{GADGET} package computes near-optimal Bayesian experimental designs using Gaussian process optimization. At its core is the ability to calculate static designs that maximize a design criterion that may be either deterministic or stochastic. In particular, stochastic design criteria could be a Monte Carlo estimator of an expected utility based on MCMC posterior draws. \code{GADGET} utilizes the algorithm proposed by Weaver et al. (2016) <doi:10.1214/15-BA945> and performs Gaussian process validation using the statistics introduced by  Bastos and O’Hagan  (2009) <doi:10.1198/TECH.2009.08019>. The \code{pbapply} package is integrated to parallelize the evaluation of the user's design criterion.  Additionally, \code{GADGET} has wrapped the optimization into a sequential routine to perform sequential computer experiments that automatically call simulator code that is available in R.
}
\references{
Weaver, B. P., Williams, B. J., Anderson-Cook, C. M., Higdon, D. M. (2016). Computational enhancements to Bayesian design of experiments using Gaussian processes. Bayesian Analysis, 11(1), 191–213, <doi:10.1214/15-BA945>.
}
\author{
Isaac Michaud, Brian Weaver, and Brian Williams
}
