% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyNumber.R
\name{FuzzyNumber}
\alias{FuzzyNumber}
\title{R6 Class representing a 'FuzzyNumber'.}
\description{
A 'FuzzyNumber' is an array of dimension nl x 3 x 1. It can be valid or not.
}
\note{
In case you find (almost surely existing) bugs or have recommendations
for improving the method, comments are welcome to the above mentioned mail addresses.
}
\examples{

## ------------------------------------------------
## Method `FuzzyNumber$new`
## ------------------------------------------------

# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3)))

# Example 2:
FuzzyNumber$new(array(c(1,2,3,4),dim=c(2,1,2)))

# Example 3:
FuzzyNumber$new(array(c(0,0.1,0.5,1,2,3),dim=c(3,2)))

# Example 4:
FuzzyNumber$new(array(c(1,2,3,4,5,6),dim=c(2,3)))

# Example 5:
FuzzyNumber$new(array(c(0,0,1,2,3,4,5,0,1),dim=c(3,3)))

# Example 6:
FuzzyNumber$new(array(c(0,0.5,1,2,3,2,5,6,7),dim=c(3,3)))

# Example 7:
FuzzyNumber$new(array(c(0,0.5,1,2,3,4,5,0,1),dim=c(3,3)))

# Example 8:
FuzzyNumber$new(array(c(0,0.5,1,2,3,4,6,5,3),dim=c(3,3)))

## ------------------------------------------------
## Method `FuzzyNumber$getFNAlphaLevels`
## ------------------------------------------------

FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getFNAlphaLevels()

## ------------------------------------------------
## Method `FuzzyNumber$is_valid`
## ------------------------------------------------

FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$is_valid()
}
\author{
Andrea Garcia Cernuda <uo270115@uniovi.es>
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FuzzyNumber-new}{\code{FuzzyNumber$new()}}
\item \href{#method-FuzzyNumber-getFNAlphaLevels}{\code{FuzzyNumber$getFNAlphaLevels()}}
\item \href{#method-FuzzyNumber-is_valid}{\code{FuzzyNumber$is_valid()}}
\item \href{#method-FuzzyNumber-clone}{\code{FuzzyNumber$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-new"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-new}{}}}
\subsection{Method \code{new()}}{
This method creates a 'FuzzyNumber' object with all its attributes set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$new(fnAlphaLevels = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fnAlphaLevels}}{is an array of dimension nl x 3 x 1 (general fuzzy number).
nl is the number of considered \eqn{\alpha}-levels and 3 is the number of
columns of the array. The first column represents the number of considered
\eqn{\alpha}-levels, the second one represents their infimum values and the
third and last column represents their supremum values.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See examples.
}

\subsection{Returns}{
The FuzzyNumber object created with all its attributes set.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Example 1:
FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3)))

# Example 2:
FuzzyNumber$new(array(c(1,2,3,4),dim=c(2,1,2)))

# Example 3:
FuzzyNumber$new(array(c(0,0.1,0.5,1,2,3),dim=c(3,2)))

# Example 4:
FuzzyNumber$new(array(c(1,2,3,4,5,6),dim=c(2,3)))

# Example 5:
FuzzyNumber$new(array(c(0,0,1,2,3,4,5,0,1),dim=c(3,3)))

# Example 6:
FuzzyNumber$new(array(c(0,0.5,1,2,3,2,5,6,7),dim=c(3,3)))

# Example 7:
FuzzyNumber$new(array(c(0,0.5,1,2,3,4,5,0,1),dim=c(3,3)))

# Example 8:
FuzzyNumber$new(array(c(0,0.5,1,2,3,4,6,5,3),dim=c(3,3)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-getFNAlphaLevels"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-getFNAlphaLevels}{}}}
\subsection{Method \code{getFNAlphaLevels()}}{
This method gives the 'fnAlphaLevels' array of the 'FuzzyNumber'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$getFNAlphaLevels()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
The array fnAlphaLevels of the FuzzyNumber object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$getFNAlphaLevels()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-is_valid"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-is_valid}{}}}
\subsection{Method \code{is_valid()}}{
This method gives information whether the 'FuzzyNumber' is valid
regarding its \eqn{\alpha}-levels, its infimum and its supremum values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$is_valid()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See examples.
}

\subsection{Returns}{
TRUE whether the FuzzyNumber object has a valid array,
otherwise FALSE.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FuzzyNumber$new(array(c(0.0,0.5,1.0,-1.5,-1.0,-1.0,2.0,1.5,1.0),dim=c(3,3))
)$is_valid()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyNumber-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyNumber-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyNumber$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
