% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-as.character.R
\docType{methods}
\name{as.character}
\alias{as.character}
\alias{as.character,FuzzyNumber-method}
\alias{as.character,PiecewiseLinearFuzzyNumber-method}
\alias{as.character,PowerFuzzyNumber-method}
\alias{as.character,TrapezoidalFuzzyNumber-method}
\title{Get Basic Information on a Fuzzy Number in a String}
\usage{
\S4method{as.character}{FuzzyNumber}(x, toLaTeX=FALSE, varnameLaTeX="A")

\S4method{as.character}{TrapezoidalFuzzyNumber}(x, toLaTeX=FALSE, varnameLaTeX="A")

\S4method{as.character}{PiecewiseLinearFuzzyNumber}(x, toLaTeX=FALSE, varnameLaTeX="A")

\S4method{as.character}{PowerFuzzyNumber}(x, toLaTeX=FALSE, varnameLaTeX="A")
}
\arguments{
\item{x}{a fuzzy number}

\item{toLaTeX}{logical; should LaTeX code be output?}

\item{varnameLaTeX}{character; variable name to be included in equations}
}
\value{
Returns a character vector.
}
\description{
This method is especially useful if you would like to
generate LaTeX equations defining a fuzzy numbers.
}
\details{
Consider calling the \code{\link{cat}} function on the resulting
string.

Thanks to Jan Caha for suggesting the \code{toLaTeX} arg.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{core}}, \code{\link{distance}},
  \code{\link{evaluate}}, \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber-class}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}}, \code{\link{arctan2}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{minimum}},
  \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityUndervaluation}}

Other PowerFuzzyNumber-method: \code{\link{PowerFuzzyNumber-class}},
  \code{\link{PowerFuzzyNumber}},
  \code{\link{alphaInterval}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{expectedInterval}}

Other conversion: \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}}
}

