% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CosFuz.R
\name{FOLP.posib}
\alias{FOLP.posib}
\title{Solves a fuzzy objective linear programming problem using Representation Theorem.}
\usage{
FOLP.posib(objective, A, dir, b, maximum = TRUE, w1 = 0.5)
}
\arguments{
\item{objective}{A vector \eqn{(c_{1}^{f}, c_{2}^{f}, ..., c_{n}^{f})}{(c1, c2, ..., cn)} of 
Trapezoidal Fuzzy Numbers with the objective function coefficients 
\eqn{f(x)=c_{1}^{f} x_1+\ldots+c_{n}^{f} x_n}{f(x)=c1*x1+\ldots+cn*xn}. Note that any of the 
coefficients may also be Real Numbers.}

\item{A}{Technological matrix of Real Numbers.}

\item{dir}{Vector of strings with the direction of the inequalities, of the same length as \code{b}. Each element 
of the vector must be one of "=", ">=", "<=", "<" or ">".}

\item{b}{Vector with the right hand side of the constraints.}

\item{maximum}{\code{TRUE} to maximize the objective function, \code{FALSE} to minimize the objective function.}

\item{w1}{Weight to be used, \code{w2} is calculated as \code{w2=1-w1}. \code{w1} must 
be in the interval \code{[0,1]}.}
}
\value{
\code{FOLP.posib} returns the solution for the given weights if the solver has found it or NULL if not.
}
\description{
The goal is to solve a linear programming problem having Trapezoidal Fuzzy Numbers 
as coefficients in the objective function (\eqn{f(x)=c_{1}^{f} x_1+\ldots+c_{n}^{f} x_n}{f(x)=c1*x1+\ldots+cn*xn}). 
\deqn{Max\, f(x)\ or\ Min\ f(x)}{Max f(x) or Min f(x)}
\deqn{s.t.:\quad Ax<=b}{s.t.:  Ax<=b}

\code{FOLP.posib} uses a possibilistic approach. This approach is based on Trapezoidal Fuzzy Numbers 
arithmetic, so the whole objective may be considered as a Fuzzy Number itself. Defining a notion of 
maximum for this kind of numbers (a weighted average of the minimum and maximum of the support of 
the Trapezoidal number).
}
\examples{
## maximize:   [0,2,3]*x1 + [1,3,4,5]*x2
## s.t.:         x1 + 3*x2 <= 6
##               x1 +   x2 <= 4
##               x1, x2 are non-negative real numbers

obj <- c(FuzzyNumbers::TrapezoidalFuzzyNumber(0,2,2,3), 
         FuzzyNumbers::TrapezoidalFuzzyNumber(1,3,4,5))
A<-matrix(c(1, 1, 3, 1), nrow = 2)
dir <- c("<=", "<=")
b <- c(6, 4)
max <- TRUE

FOLP.posib(obj, A, dir, b, maximum = max, w1=0.2)

}
\references{
Dubois, D. and Prade, H. Operations in fuzzy numbers. International Journal of Systems Science, 9:613-626, 1978.
}
\seealso{
\code{\link{FOLP.ordFun}}, \code{\link{FOLP.multiObj}}, \code{\link{FOLP.interv}}, \code{\link{FOLP.strat}}
}
