% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.interval.ages.R
\name{sim.interval.ages}
\alias{sim.interval.ages}
\title{Reassign fossil ages to user-specified stratigraphic intervals}
\usage{
sim.interval.ages(fossils, tree = NULL, taxonomy = NULL,
  interval.ages = NULL, max.age = NULL, strata = NULL,
  use.species.ages = FALSE, root.edge = TRUE, sim.extant = FALSE)
}
\arguments{
\item{fossils}{Fossil object.}

\item{tree}{Phylo object.}

\item{taxonomy}{Taxonomy object.}

\item{interval.ages}{Vector of stratigraphic interval ages, starting with the minimum age of the youngest interval and ending with the maximum age of the oldest interval.}

\item{max.age}{Maximum age of the oldest stratigraphic interval.}

\item{strata}{Number of stratigraphic intervals.}

\item{use.species.ages}{If TRUE reassigned fossil ages will respect the speciation times. Default = FALSE.}

\item{root.edge}{If TRUE include root edge.}

\item{sim.extant}{If TRUE simulate age uncertainty for extant samples as well, default FALSE.}
}
\value{
An object of class fossils.
}
\description{
Reassign exact fossil ages using the minimum and maximum ages of a set of stratigraphic intervals.
If \code{use.species.ages = TRUE} the function will respect species durations and will not
return minimum and maximum bounds that may be younger or older than the species durations.
This requires supplying a phylo or taxonomy object.
}
\examples{
# simulate tree
t = ape::rtree(8)

# simulate fossils
rate = 2
f = sim.fossils.poisson(rate, t)
plot(f, t)

# assign a max age based on tree height
max.age = tree.max(t)

# define intervals
times = seq(0, max.age, length.out = 5)

# reassign ages
f = sim.interval.ages(f, t, interval.ages = times)

# plot output
plot(f, t, interval.ages = times)

}
