% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.fbd.R
\name{sim.fbd.taxa}
\alias{sim.fbd.taxa}
\title{sim.fbd.taxa: Simulating fossilized birth-death trees on a fixed number of extant taxa.}
\usage{
sim.fbd.taxa(n, numbsim, lambda, mu, psi, frac = 1, complete = FALSE)
}
\arguments{
\item{n}{Number of extant sampled tips.}

\item{numbsim}{Number of trees to simulate.}

\item{lambda}{Speciation rate.}

\item{mu}{Extinction rate.}

\item{psi}{Fossil sampling rate.}

\item{frac}{When complete = FALSE: The actual
number of extant tips is n/frac, but only n tips are included
(incomplete sampling). When complete = TRUE: all extinct and
non-sampled lineages are included, i.e. the tree has n/frac
extant tips.}

\item{complete}{If TRUE, the tree with the extinct and non-sampled lineages
is returned. If FALSE, the extinct lineages are suppressed.}
}
\value{
List of numbsim simulated SAtrees with n extant sampled tips.
}
\description{
sim.fbd.taxa: Simulating fossilized birth-death trees on a fixed number of extant taxa.
}
\examples{
n = 10
lambda = 2.0
mu = 0.5
psi = 0.6
numbsim = 2
sim.fbd.taxa(n, numbsim, lambda, mu, psi)
}
\keyword{birth}
\keyword{death}
\keyword{fossilized}
