% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeTopSummary.R
\name{TreeTopSummary}
\alias{TreeTopSummary}
\title{Treetop Summary}
\usage{
TreeTopSummary(treetops, areas = NULL, grid = NULL, variables = NULL)
}
\arguments{
\item{treetops}{\link[sp]{SpatialPointsDataFrame}. The point location of a set of treetops. Typically
detected from a canopy height model using \code{\link{TreeTopFinder}}. Tree attributes, such as height
or crown size, should be stored within this object's \code{@data} slot.}

\item{areas}{\link[sp]{SpatialPolygonsDataFrame}. An optional set of polygons corresponding to areas of
interest. Tree counts and statistics will be returned for each area.}

\item{grid}{RasterLayer (see \link[raster]{raster}) or numeric. Similar to the \code{areas} argument, using \code{grid}
will compute tree count and statistics according to a spatial grid. Grid size and placement can be defined
by using a \link[raster]{raster} object. If a single numeric value is used, the function will generate a
grid with a cell size equal to this value.}

\item{variables}{character. The names of tree attribute variables (stored in \code{treetops@data} slot).
 In addition to tree counts, the function will compute statistics (mean, median, standard deviation, minimum and
maximum) for each of these variables. Only numeric values are accepted.}
}
\value{
Tree count and, if any \code{variables} are supplied, tree attribute statistics. If no
\code{areas} or \code{grid} is supplied, the tree count and statistics are computed for the entire
\code{treetops} dataset, and returned as a 'data.frame' object. If \code{areas} are defined, an
identical \link[sp]{SpatialPolygonsDataFrame} will be returned, with all computed statistics appended
to the object's \code{@data} slot. If a \code{grid} is defined, tree count will be returned as a RasterLayer,
with cell values equal to the number of trees in each cell. If a \code{grid} and \code{variables} are defined,
a RasterBrick (see \link[raster]{brick}) will be returned instead, with tree count and attribute statistics
stored as separate layers.
}
\description{
Summarization tool for calculating tree counts and tree height statistics within a given area
}
\examples{
# Load sample data
library(ForestTools)
library(sp)
data("kootenayTrees", "kootenayBlocks")

# Get total tree count
TreeTopSummary(kootenayTrees)

# Get total tree count and tree height statistics
TreeTopSummary(kootenayTrees, variables = "height")

# Get tree count and height statistics for specific areas of interest
areaStats <- TreeTopSummary(kootenayTrees, areas = kootenayBlocks, variables = "height")

# Plot according to tree count
plot(areaStats, col = heat.colors(3)[order(areaStats$TreeCount)])

# Get tree count and height statistics for a 20 x 20 m spatial grid
gridStats <- TreeTopSummary(kootenayTrees, grid = 20, variables = "height")

# Plot gridded tree count and statistics
plot(gridStats$TreeCount)
plot(gridStats$heightMax)

}
\seealso{
\code{\link{TreeTopFinder}}
}

