% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctbu.R
\name{ctbu}
\alias{ctbu}
\title{Bottom-up Cross-temporal forecast reconciliation}
\usage{
ctbu(Bmat, m, C)
}
\arguments{
\item{Bmat}{(\code{nb x (h m)}) matrix of high-frequency bottom time series base forecasts.
\code{h} is the forecast horizon for the lowest frequency (most temporally aggregated)
time series.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order of temporal aggregation).}

\item{C}{(\code{na x nb}) cross-sectional (contemporaneous) matrix mapping the bottom
level series into the higher level ones.}
}
\value{
The function returns a (\code{n x (h (k* + m))}) matrix of
bottom-up cross-temporally reconciled forecasts.
}
\description{
Cross temporal reconciled forecasts for all series at any temporal
aggregation level can be easily computed by appropriate summation of the high-frequency
bottom base forecasts \eqn{\hat{\textbf{b}}_i, i = 1,...,n_b, \;}{} according to a
bottom-up procedure like what is currently done in both the cross-sectional
and temporal frameworks.
}
\examples{
data(FoReco_data)
id <- which(simplify2array(strsplit(colnames(FoReco_data$base),
                                    split = "_"))[1, ] == "k1")
hfbts <- FoReco_data$base[-c(1:3), id]
obj <- ctbu(Bmat = hfbts, m = 12, C = FoReco_data$C)
rownames(obj) <- rownames(FoReco_data$base)

}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\keyword{bottom-up}
\keyword{reconciliation}
