## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(FnR)

## -----------------------------------------------------------------------------
(ped <- data.frame(
  ID = 1:12,
  SIRE = c(0, 0, 0, 2, 2, 0, 4, 6, 0, 6, 10, 10),
  DAM = c(0, 0, 0, 1, 1, 0, 3, 5, 7, 8, 9, 0)
))

## -----------------------------------------------------------------------------
oldped <- ped[1:9, ]
(oldrun <- resume_inbreed(oldped, export_d = TRUE))

## -----------------------------------------------------------------------------
resume_inbreed(ped)

## -----------------------------------------------------------------------------
resume_inbreed(ped, f = oldrun$f)

## -----------------------------------------------------------------------------
resume_inbreed(ped, f = oldrun$f, d = oldrun$d)

## -----------------------------------------------------------------------------
calcR(ped, set1 = c(12, 6), set2 = c(11, 8), type = "notdam-notsire")

## -----------------------------------------------------------------------------
calcR(ped, set1 = 7, set2 = 8:9, type = "dam-dam")

## -----------------------------------------------------------------------------
calcR(ped, set1 = c(2, 6), set2 = c(4, 10), type = "sire-sire")

