% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/station.info.R
\name{station.info}
\alias{station.info}
\title{Retrieve Station Info}
\usage{
station.info(TS, StnInfo = NULL, Plot = F, language = "English")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow}

\item{StnInfo}{Optional data.frame containing user-supplied station info for plot. 
data.frame must have 7 columns containing station info in the following order:
Station ID, Station Name, Prov/State, Country, Latitude, Longitude, Catchment Area
If any of the information is unavailabe, fill with NA.  The Station ID column must
match the Station ID in column 1 of the data.frame input from \code{\link{create.ts}}.}

\item{Plot}{Boolean indicating whether a plot of station information should be created.
Default is F. Plot is intended for use as the upper-left panel of the plot produced 
by \code{\link{screen.summary}}.}

\item{language}{Language for plotting when Plot = T.  Choice of either "English" or
"French". Default is "English".}
}
\value{
Returns a list of the following station information:
  \itemize{
    \item $StationID
    \item $StnName
    \item $Prov/State - Abbreviation for the province or state in which the station is located
    \item $Country - Abbreviation for the country in which the station is located
    \item $Lat - Latitude of the station
    \item $Long - Longitude of the station
    \item $Area - Catchment area, in square kilometers
    \item $RHN - Boolean indicating whether the station is part of a reference hydrologic network
  }
}
\description{
Returns station information for Water Survey Canada or United States Geological Survey stream 
gauges.
}
\examples{
data(cania.sub.ts)
StnInfo <- station.info(cania.sub.ts)
}
\author{
Jennifer Dierauer
}

