% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rFB}
\alias{rFB}
\title{Random generator from the flexible beta distribution}
\usage{
rFB(n, mu, phi, p, w)
}
\arguments{
\item{n}{the number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{mu}{the mean parameter of the flexible beta distribution. It must lie in (0, 1).}

\item{phi}{the precision parameter of the Flexible Beta distribution. It must be a positive real value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{w}{the normalized distance among clusters. It must lie in (0, 1).}
}
\value{
A vector of length  \code{n}.
}
\description{
The function randomly generates values from the flexible beta distribution.
}
\examples{
rFB(100,0.5,30,0.3,0.6)

}
\references{
{
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079
}
}
