% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.firm_register.R
\name{find.firm}
\alias{find.firm}
\title{Function to create a \code{firm} (legal person) using data from 'Yahoo! Finance'}
\usage{
find.firm(
  ticker,
  name = NULL,
  ticker_is_id = TRUE,
  legal_form = NULL,
  sector_granularity = 1,
  managers_remove_salutation_title = TRUE,
  managers_only_surname = FALSE
)
}
\arguments{
\item{ticker}{Firm's ticker.}

\item{name}{Provide the firm's name. If not provided, \code{NA}, or \code{NULL}, will default to the string provided as \code{ticker}.}

\item{ticker_is_id}{Should the ticker be used as the firm's id?}

\item{legal_form}{The firm's legal form of the firm. Possible values:
- a string (e.g., 'LLC', 'Private', 'GmbH', etc.);
- \code{NULL} (default), in which case the function will set \code{legal_form} to 'JSC'; or
- \code{NA} to specify no legal form.}

\item{sector_granularity}{Sector in which the firm operates. Possible values:
- \code{0}, \code{NULL}, or \code{NA} to omit the sector;
- \code{1} or \code{'generic'} (default) for a generic description (e.g., 'Consumer Technology', 'Consumer Cyclical', 'Consumer Defensive');
- \code{2} or \code{'specifc'} for a more granular description (e.g., 'Technology', 'Auto Manufacturers', 'Tobacco').}

\item{managers_remove_salutation_title}{Yahoo! Finance provide salutation titles before the names of the managers. If this is \code{TRUE} (default), they will be omitted.}

\item{managers_only_surname}{Yahoo! Finance provide first, middle, and last name of the managers. If this is \code{TRUE} (not recommended for large data sets), only the surname is returned.}
}
\value{
An object of the S4 class \code{firm} containing several fields, only the first one of which is mandatory:
\item{name}{Name of the firm (or ticker if no name was provided)}
\item{id}{Firm' ticker (if ticker_is_id was `TRUE`) or nothing (otherwise)}
\item{legal_form}{Legal form of the firm (may be null)}
\item{sector}{Sector in which the firm operates (may be null)}
\item{revenues}{Yearly revenues}
\item{capitalisation}{Capitalisation}
\item{management}{Members of the board}
\item{ownership}{Owner(s)}
\item{shares}{Share owned by (each of) the owner(s)}
\item{currency}{Currency}
}
\description{
Tickers can be retrieved from [Yahoo! Finance](https://finance.yahoo.com/lookup/).
This function requires the package \code{yahoofinancer} to be installed. It is available from the CRAN by running \code{install.packages('yahoofinancer')}.
}
\examples{
# Registering Apple automatically
#| Results are subject to the correct functioning of the package `yahoofinancer`
#| and of the Yahoo! Finance API

}
\seealso{
\link{register.firm} \link{find.firms}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
