% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_either.R
\name{FF.naive.ownership}
\alias{FF.naive.ownership}
\title{Create a naive-valued firm-firm (FF) matrix for common ownership}
\usage{
FF.naive.ownership(
  ...,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a naive-valued firm-firm (FF) matrix based on common ownership
}
\details{
Naive-valued means simply counting the number of common owners
}
\examples{

# Create the naive FF matrix of Berkshire Hathaway's holdings by common ownership
data('firms_BKB')
FF <- FF.naive.ownership(firms_BKB)

}
\seealso{
\link{FF} \link{FF.binary.ownership} \link{FF.binary.management} \link{FF.naive.management} \link{FF.norm.ownership} \link{FF.norm.management}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
