% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_trial_error.R
\name{field_trial_error}
\alias{field_trial_error}
\title{Simulate plot errors in multi-environment field trials}
\usage{
field_trial_error(
  n_envs = 1,
  n_traits = 1,
  n_blocks = 2,
  n_cols = 10,
  n_rows = 20,
  block_dir = "col",
  var_R = 1,
  S_cor_R = NULL,
  R_cor_R = NULL,
  E_cor_R = NULL,
  spatial_model = "Bivariate",
  complexity = NULL,
  plot_length = 5,
  plot_width = 2,
  col_cor = 0.5,
  row_cor = 0.7,
  prop_spatial = 0.4,
  prop_ext = 0,
  ext_dir = "row",
  ext_ord = "random",
  return_effects = FALSE
)
}
\arguments{
\item{n_envs}{Number of environments to be simulated (same number used for \code{compsym_asr_input}
or \code{unstr_asr_output}, where applicable).}

\item{n_traits}{Number of traits to be simulated.}

\item{n_blocks}{A vector specifying the number of blocks in each environment.
If only one value is provided, all environments will be assigned the same number.}

\item{n_cols}{A vector specifying the total number of columns in each environment. If only one
value is provided, all environments will be assigned the same number.}

\item{n_rows}{A vector specifying the total number of rows in each environment. If only one
value is provided, all environments will be assigned the same number.}

\item{block_dir}{A vector specifying the block direction in each environment. Use
'col' for a side-by-side arrangement (default), 'row' for an above-and-below arrangement, or
NA if only one block is simulated. If only one value is provided, all environments
will be assigned the same block direction (where applicable).}

\item{var_R}{A vector of error variances for each environment-within-trait combination. If only
one value is provided, all environment-within-trait combinations will be assigned the same
error variance.}

\item{S_cor_R}{A matrix of spatial error correlations between traits. If not specified and
spatial error is simulated, a diagonal matrix is constructed.}

\item{R_cor_R}{A matrix of random error correlations between traits. If not specified and
random error is simulated, a diagonal matrix is constructed.}

\item{E_cor_R}{A matrix of extraneous error correlations between traits. If not specified and
an extraneous error is simulated, a diagonal matrix is constructed. \cr
\strong{Note:} the same correlation between traits is used for the column and row errors
(where applicable). Currently only implemented when \code{ext_ord = "random"}.}

\item{spatial_model}{A character string specifying the model used to simulate the two-dimensional
spatial error term. One of either 'Bivariate' (bivariate interpolation, the default) or 'AR1:AR1'
(separable first-order autoregressive process).}

\item{complexity}{A vector specifying the complexity of the bivariate interpolation in each
environment. If only one value is provided, all environments will be assigned the same complexity.
If not specified and \code{spatial_model = "Bivariate"}, the complexity is set to half the maximum
number of columns and rows in each environment. This generally provides good results. See
\href{https://CRAN.R-project.org/package=interp}{`interp'} for further details.}

\item{plot_length}{A vector of plot lengths (column direction, usually longer side) for each
environment. If only one value is provided, all environments will be assigned the same plot
length. Only required when \code{spatial_model = "Bivariate"}.}

\item{plot_width}{A vector of plot widths (row direction, usually shorter side) for each
environment. If only one value is provided, all environments will be assigned the same plot
width. Only required when \code{spatial_model = "Bivariate"}.}

\item{col_cor}{A vector of column autocorrelations for each environment used in the AR1:AR1
spatial error model. If only one value is provided, all environments will be assigned the same
column autocorrelation. Only required when \code{spatial_model = "AR1:AR1"}.}

\item{row_cor}{A vector of row autocorrelations for each environment used in the AR1:AR1 spatial
error model. If only one value is provided, all environments will be assigned the same row
autocorrelation. Only required when \code{spatial_model = "AR1:AR1"}.}

\item{prop_spatial}{A vector specifying the proportion of spatial error variance to total error
variance (spatial + random + extraneous) for each environment-within-trait combination. If only
one value is provided, all environment-within-trait combinations will be assigned the proportion
of spatial error variance.}

\item{prop_ext}{A vector specifying the proportion of extraneous error variance to total error
variance (spatial + random + extraneous) for each environment-within-trait combination. If only
one value is provided, all environment-within-trait combinations will be assigned the proportion
of extraneous error variance.}

\item{ext_dir}{A vector specifying the direction of extraneous variation for each environment.
Use 'col' to simulate variation in the column direction, 'row' (default) for variation in the
row direction, 'both' for variation in both directions, or NA if zero extraneous variation is
simulated. When \code{ext_dir = "both"}, half the variance is assigned to the columns and
half is assigned to the rows. If only one value is provided, all environments will be
assigned the same direction (where applicable).}

\item{ext_ord}{A character string specifying the method used to simulate the extraneous error term.
One of either 'random' (the default) or 'zig-zag'. The zig-zag ordering is achieved by alternating
positive and negative values between neighbouring columns and rows.}

\item{return_effects}{When \code{TRUE}, a list is returned with additional entries for each trait
containing the spatial, random and extraneous errors. By default, \code{return_effects = FALSE}.}
}
\value{
A data frame with columns 'env', 'block', 'col' and 'row', as well as the
  simulated error for each trait. When \code{return_effects = TRUE}, a list is returned with
  additional columns for each trait providing the spatial, random and extraneous errors.
}
\description{
Creates a data frame of simulated plot errors for multi-environment field trials with one or
more traits. The plot errors comprise spatially correlated error (trend), random error (noise)
and extraneous error. The spatially correlated error is simulated according to either
1) bivariate interpolation using the \code{interp} function of the package
\href{https://CRAN.R-project.org/package=interp}{`interp'}, or 2) a separable first-order
autoregressive process (AR1:AR1). The random error is simulated using an independent process.
The extraneous error is simulated as the sum of column and/or row terms, where the user can
choose from an independent or a correlated process. The spatially correlated, random, and extraneous
errors are combined according to a user-defined ratio. \cr
For multiple traits, correlated errors can be simulated assuming 1) correlated spatial error
between traits, 2) correlated random error between traits, 3) correlated extraneous error
between traits, or 4) some combination of 1-3. \cr
A separable correlation structure is assumed between traits and environments, but different
variances can be assigned to different environment-within-trait combinations.
}
\examples{
# Simulate plot errors for two traits across two environments using an AR1 model
# for spatial variation.

# Error variances for the four environment-within-trait combinations.
var_R <- c(0.2, 0.4, 10, 15) # Trait 1 x 2 environments, trait 2 x 2 environments.

# Spatial error correlations between the two simulated traits.
S_cor_R <- matrix(
  c(
    1.0, 0.2,
    0.2, 1.0
  ),
  ncol = 2
)

error_df <- field_trial_error(
  n_envs = 2,
  n_traits = 2,
  n_blocks = c(2, 2),
  n_cols = 10,
  n_rows = c(20, 20),
  block_dir = "row",
  var_R = var_R,
  S_cor_R = S_cor_R,
  spatial_model = "AR1:AR1",
  col_cor = 0.5,
  row_cor = 0.7,
  prop_spatial = 0.4,
  prop_ext = 0.2,
  ext_dir = "row",
  ext_ord = "random",
  return_effects = FALSE
)
}
