% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_do_optim.R
\name{sparse_allocation}
\alias{sparse_allocation}
\title{Unreplicated designs using the sparse allocation approach}
\usage{
sparse_allocation(
  lines,
  nrows,
  ncols,
  l,
  planter = "serpentine",
  plotNumber,
  copies_per_entry,
  checks = NULL,
  exptName = NULL,
  locationNames,
  sparse_list,
  seed,
  data = NULL
)
}
\arguments{
\item{lines}{Number of genotypes, experimental lines or treatments.}

\item{nrows}{Number of rows in the field.}

\item{ncols}{Number of columns in the field.}

\item{l}{Number of locations or sites. By default  \code{l = 1}.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} plot arrangement. 
By default  \code{planter = 'serpentine'}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. 
By default \code{plotNumber = 101}.}

\item{copies_per_entry}{Number of copies per plant. 
When design is \code{sparse} then \code{copies_per_entry} < \code{l}}

\item{checks}{Number of genotypes checks.}

\item{exptName}{(optional) Name of the experiment.}

\item{locationNames}{(optional) Names each location.}

\item{sparse_list}{(optional) A class "Sparse" object generated by \code{do_optim()} function.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with 2 columns: \code{ENTRY | NAME }. ENTRY must be numeric.}
}
\value{
A list with four elements.
\itemize{
  \item \code{designs} is a list with each location unreplicated randomization.
  \item \code{list_locs} is a list with each location list of entries.
  \item \code{allocation} is a matrix with the allocation of treatments.
  \item \code{size_locations} is a data frame with one column for each 
 location and one row with the size of the location.
}
}
\description{
Unreplicated designs using the sparse allocation approach
}
\examples{
sparse <- sparse_allocation(
  lines = 120, 
  l = 4, 
  copies_per_entry = 3, 
  checks = 4, 
  locationNames = c("LOC1", "LOC2", "LOC3", "LOC4", "LOC5"), 
  seed = 1234
)
}
\references{
Edmondson, R.N. Multi-level Block Designs for Comparative Experiments. JABES 25, 
500–522 (2020). https://doi.org/10.1007/s13253-020-00416-0
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb]
}
