% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_RCBD.R
\name{RCBD}
\alias{RCBD}
\title{Generates a Randomized Complete Block Design (RCBD)}
\usage{
RCBD(
  t = NULL,
  reps = NULL,
  l = 1,
  plotNumber = 101,
  continuous = FALSE,
  planter = "serpentine",
  seed = NULL,
  locationNames = NULL,
  data = NULL
)
}
\arguments{
\item{t}{An integer number with total number of treatments or a vector of dimension t with labels.}

\item{reps}{Number of replicates (full blocks) of each treatment.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{continuous}{Logical value for plot number continuous or not. By default \code{continuous = FALSE}.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} arrangement. By default \code{planter = 'serpentine'}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{locationNames}{(optional) Names for each location.}

\item{data}{(optional) Data frame with the labels of treatments.}
}
\value{
A list with five elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{layoutRandom} is the RCBD layout randomization for each location.
  \item \code{plotNumber} is the plot number layout for each location.
  \item \code{fieldBook} is a data frame with the RCBD field book design.
}
}
\description{
It randomly generates a randomized complete block design (RCBD) across locations.
}
\examples{
# Example 1: Generates a RCBD design with 3 blocks and 20 treatments across 3 locations.
rcbd1 <- RCBD(t = LETTERS[1:20], reps = 5, l = 3, 
              plotNumber = c(101,1001, 2001), 
              continuous = TRUE,
              planter = "serpentine", 
              seed = 1020, 
              locationNames = c("FARGO", "MINOT", "CASSELTON"))
rcbd1$infoDesign                  
rcbd1$layoutRandom
rcbd1$plotNumber
head(rcbd1$fieldBook)

# Example 2: Generates a RCBD design with 6 blocks and 18 treatments in one location.
# In this case, we show how to use the option data.
treatments <- paste("ND-", 1:18, sep = "")
treatment_list <- data.frame(list(TREATMENT = treatments))
head(treatment_list)
rcbd2 <- RCBD(reps = 6, l = 1, 
              plotNumber = 101, 
              continuous = FALSE, 
              planter = "serpentine", 
              seed = 13, 
              locationNames = "IBAGUE",
              data = treatment_list)
rcbd2$infoDesign                  
rcbd2$layoutRandom
rcbd2$plotNumber
head(rcbd2$fieldBook)


}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
