% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UTILITY_FUNCTIONS.R
\name{agol_filter}
\alias{agol_filter}
\title{Scaffolds the common pattern of selecting a layer and filter a geometry from
an ArcGIS feature service.}
\usage{
agol_filter(url, layer_name = NULL, geom, simplify = TRUE)
}
\arguments{
\item{url}{the url of the remote resource. Must be of length one.}

\item{layer_name}{the name(s) associated with the layer you want
to retrieve. Can be a character vector. If \code{NULL} (the default),
iterates through all layers.}

\item{geom}{an object of class \code{bbox}, \code{sfc} or \code{sfg} used to filter query
results based on a predicate function.}

\item{simplify}{when only one layer exists, just return the \code{sf} object or
\code{data.frame}, otherwise return a list of these objects.}
}
\value{
An \code{sf} object, or a \code{data.frame}, or a list of these objects if
\code{layer_name == NULL} or if \code{length(layer_name) > 1}. Missing layers return
"NULL".
}
\description{
This function uses the arcgislayers package, which has has had compatibility
issues for several commonly used platforms. It is mainly here for historical
reasons.
}
\examples{
\dontrun{

# Get a single layer
agol_filter(
  url = "https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer/",
  layer_name = "WBDHU12",
  geom = FedData::meve
)

# Can be returned as a list
agol_filter(
  url = "https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer/",
  layer_name = "WBDHU12",
  geom = FedData::meve,
  simplify = FALSE
)

# Get a list with all layers
agol_filter(
  url = "https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer/",
  geom = FedData::meve
)

# Or include a vector of layer names
# Note that missing layers are returned as `NULL` values
agol_filter(
  url = "https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer/",
  layer_name = c(
    "NHDPoint",
    "NetworkNHDFlowline",
    "NonNetworkNHDFlowline",
    "NHDLine",
    "NHDArea",
    "NHDWaterbody"
  ),
  geom = FedData::meve
)
}

}
\keyword{internal}
