% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NED_FUNCTIONS.R
\name{getNED}
\alias{getNED}
\title{Download and crop the 1 (~30 meter) or 1/3 (~10 meter) arc-second National Elevation Dataset.}
\usage{
getNED(template, label, res = NULL, raw.dir = "./RAW/NED/",
  extraction.dir = "./EXTRACTIONS/NED/", force.redo = F)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping, and perhaps resolution. If a Raster* with
a resolution that is less than 1/3 arc-second, \code{getNED} defaults to the 1/3
arc-second dataset. Otherwise, it defaults to the 1 arc-second dataset.}

\item{label}{A character string naming the study area.}

\item{res}{A character string representing the desired resolution of the NED. "1"
indicates the 1 arc-second NED, while "13" indicates the 1/3 arc-second dataset. Defaults to NULL.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NED/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped DEM should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/NED/".}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A \code{RasterLayer} DEM cropped to the extent of the template.
}
\description{
\code{getNED} returns a \code{RasterLayer} of elevation data cropped to a given
template study area.
}

